<?php get_header(); ?>

<main class="l-main">
  <section class="s-slick">

    <div class="ttl-block">
      <div class="wrapper">
        <h3>
          <span class="en">Articles</span>
          <!-- 日々の読書をもっと楽しく -->
        </h3>
      </div>
    </div>

    <div class="slick-main">
      <ul class="slick-cards">
        <?php
        $args = array(
          'posts_per_page' => 5,
          'post_type'      => 'post',
          'orderby'        => 'date',
          'order'          => 'DESC',
        );

        $latest_posts = new WP_Query($args);

        if ($latest_posts->have_posts()) :
          while ($latest_posts->have_posts()) : $latest_posts->the_post(); ?>
            <li class="card">
              <a href="<?php the_permalink(); ?>">
                <div class="img-wrap">
                  <div class="img">
                    <?php if (has_post_thumbnail()) : ?>
                      <?php the_post_thumbnail('medium'); ?>
                    <?php endif; ?>
                  </div>
                  <div class="category">
                    <?php
                    $categories = get_the_category();
                    if ($categories) {
                      echo esc_html($categories[0]->name);
                    }
                    ?>
                  </div>
                </div>
                <div class="title-wrap">
                  <div class="pikup">pikup</div>
                  <h3><?php the_title(); ?></h3>
                </div>
                <?php
                $tags = get_the_tags();
                if ($tags) :
                ?>
                  <div class="tag-wrap">
                    <ul class="tag-list">
                      <?php
                      foreach ($tags as $tag) {
                        echo '<li>#' . esc_html($tag->name) . '</li>';
                      }
                      ?>
                    </ul>
                  </div>
                <?php endif; ?>
              </a>
            </li>
        <?php
          endwhile;
          wp_reset_postdata();
        endif;
        ?>
      </ul>

    </div>



  </section>

  <section class="s-news">
    <div class="ttl-block">
      <div class="wrapper">
        <h3>
          <span class="en">ALL</span>
          <!-- 編集ライターが届ける書籍情報 -->
        </h3>
      </div>
    </div>
    <div class="wrapper">
      <div class="news-main">
        <ul class="news-cards">
          <?php
          $paged = max(1, get_query_var('paged'), get_query_var('page'));
          $posts_per_page = get_option('posts_per_page');

          $args = array(
            'posts_per_page' => $posts_per_page,
            'post_type'      => 'post',
            'orderby'        => 'date',
            'order'          => 'DESC',
            'paged'          => $paged
          );

          $latest_posts = new WP_Query($args);

          if ($latest_posts->have_posts()) :
            while ($latest_posts->have_posts()) : $latest_posts->the_post(); ?>

              <?php get_template_part('template-parts/card-loop'); ?>

            <?php endwhile; ?>
          <?php else : ?>
            <li class="no-posts">該当する記事はありません。</li>
          <?php endif; ?>

        </ul>
        <?php
        $posts_page_id = get_option('page_for_posts');
        $posts_url = $posts_page_id ? get_permalink($posts_page_id) : home_url('/');
        ?>
        <a href="<?php echo esc_url($posts_url); ?>" class="more-btn">一覧を見る</a>







      </div>

    </div>

  </section>

  <!-- <section class="s-tag">

    <div class="ttl-block">
      <div class="wrapper">
        <h3>
          <span class="en">Tag</span>
          おすすめタグで絞り込む
        </h3>
      </div>
    </div>
    <div class="tag-wrap">
      <div class="wrapper">
        <ul class="tags">
          <li>＃小説</li>
          <li>＃ビジネス書</li>
          <li>＃コミック</li>
          <li>＃ベストセラー</li>
          <li>＃フェア情報</li>
        </ul>
      </div>
    </div>


  </section>
 -->


</main>


<?php get_footer(); ?>