
<?php
// CSS と JS を読み込む関数
function my_theme_enqueue_assets()
{
	// CSS
	wp_enqueue_style('main-style', get_template_directory_uri() . '/css/style.css', [], wp_get_theme()->get("Version"));

	// Slick CSS
	wp_enqueue_style('slick-style', get_template_directory_uri() . '/css/plugin/slick.css', [], '1.8.1');
	wp_enqueue_style('slick-theme-style', get_template_directory_uri() . '/css/plugin/slick-theme.css', ['slick-style'], '1.8.1');

	// Google Fonts
	wp_enqueue_style(
		'google-fonts',
		'https://fonts.googleapis.com/css2?family=Instrument+Sans:ital,wght@0,400..700;1,400..700&family=Noto+Sans+JP:wght@100..900&family=Noto+Sans:ital,wght@0,100..900;1,100..900&family=M+PLUS+2:wght@400;700&display=swap',
		array(),
		null
	);

	// jQuery（WordPress 同梱のバージョンを使う場合）
	wp_enqueue_script('jquery');

	// slick
	wp_enqueue_script('slick', get_template_directory_uri() . '/js/slick.min.js', array('jquery'), null, true);

	// common.js（あなたのオリジナルJS）
	wp_enqueue_script('common-js', get_template_directory_uri() . '/js/common.js', array('jquery', 'slick'), null, true);
}
add_action('wp_enqueue_scripts', 'my_theme_enqueue_assets');

// ===== メニュー機能=====
// メニュー機能を有効化
add_theme_support('menus');
// 表示位置を登録
register_nav_menus([
	'global-menu' => 'グローバルメニュー',
	'sns-menu'    => 'SNSメニュー',
]);
// ===== SNSメニューはアイコンだけ表示 =====
add_filter('nav_menu_item_title', function ($title, $item, $args) {
	if ($args->theme_location === 'sns-menu') {
		return '<span class="sns-icon" aria-hidden="true"></span>'
			. '<span class="screen-reader-text">' . esc_html($item->title) . '</span>';
	}
	return $title;
}, 10, 3);
