<!DOCTYPE html>
<html lang="ja">

<head>
	<meta charset="UTF-8" />
	<meta name="viewport" content="width=device-width, initial-scale=1.0" />
	<title><?php echo is_front_page() ? 'Home' : get_the_title(); ?> | <?php bloginfo('name'); ?></title>

	<!-- OGP -->
	<meta property="og:title" content="<?php bloginfo('name'); ?>" />
	<meta property="og:description" content="ページの説明" />
	<meta property="og:image" content="画像のURL" />
	<meta property="og:url" content="<?php echo esc_url(home_url()); ?>" />
	<meta property="og:type" content="website" />
	<meta property="og:site_name" content="<?php bloginfo('name'); ?>" />
	<meta name="twitter:card" content="summary_large_image" />
	<meta name="twitter:site" content="@your_account">


	<?php wp_head(); ?>
</head>



<body <?php body_class(); ?>>
	<!-- header -->
	<header class="l-header">

		<div class="nav-hide">
			<div class="wrapper">
				<div class="hidemenu-wrap">
					<form method="get" action="<?php echo home_url('/'); ?>">


						<ul class="menu-block">
							<li>

								<!-- カテゴリ -->
								<div class="menu-title">
									<div class="menu-l">
										<span class="img">
											<img src="<?php echo get_template_directory_uri(); ?>/images/icon-category.png" alt="icon-category">
										</span>
										<span class="en">Category</span>
									</div>
									<div class="menu-r">おすすめカテゴリで絞り込む</div>
								</div>
								<ul class="menu-list category-list">
									<?php
									$categories = get_categories(array(
										'orderby' => 'name',
										'order'   => 'ASC',
										'hide_empty' => true
									));
									foreach ($categories as $category) : ?>
										<li>
											<input type="radio" id="cat-<?php echo $category->term_id; ?>"
												name="cat" value="<?php echo $category->term_id; ?>" hidden>
											<label for="cat-<?php echo $category->term_id; ?>" class="select-btn">
												<a href="<?php echo esc_url(get_category_link($category->term_id)); ?>"><?php echo esc_html($category->name); ?></a>
											</label>
										</li>
									<?php endforeach; ?>
								</ul>
							</li>
							<li>
								<!-- タグ -->
								<div class="menu-title">
									<div class="menu-l">
										<span class="img">
											<img src="<?php echo get_template_directory_uri(); ?>/images/icon-tag.png" alt="icon-tag">
										</span>
										<span class="en">Tag</span>
									</div>
									<div class="menu-r">おすすめタグで絞り込む

									</div>
								</div>
								<ul class="menu-list tag-list">
									<?php
									$tags = get_tags(array(
										'orderby'    => 'name',
										'order'      => 'ASC',
										'hide_empty' => true
									));
									foreach ($tags as $tag) : ?>
										<li>
											<input type="radio" id="tag-<?php echo $tag->term_id; ?>"
												name="tag" value="<?php echo $tag->slug; ?>" hidden>
											<label for="tag-<?php echo $tag->term_id; ?>" class="select-btn">
												<a href="<?php echo esc_url(get_category_link($tag->term_id)); ?>">＃<?php echo esc_html($tag->name); ?></a>
											</label>
										</li>
									<?php endforeach; ?>
								</ul>

							</li>

						</ul>
					</form>




					<ul class="sns-block">

						<?php
						wp_nav_menu([
							'theme_location' => 'sns-menu',
							'container'      => false,
							'items_wrap'     => '%3$s',
						]);
						?>

					</ul>
				</div>




			</div>
		</div>

		<div class="main-flex">
			<div class="logo-block">
				<a href="<?php echo home_url(); ?>" class="logo">
					<?php echo get_bloginfo('name'); ?>
				</a>
			</div>


			<!-- 追従メニュー -->
			<div class="menu-content menu-content__header">
				<nav class="nav">

					<?php
					wp_nav_menu([
						'theme_location' => 'global-menu',
						'container'      => false,
						'menu_class'     => 'nav-list',
						'fallback_cb'    => false,
					]);
					?>
				</nav>
				<button class="burger" aria-label="menu">
					<div class="burger-toggle">
						<span></span><span></span>
					</div>
				</button>
			</div>
		</div>

	</header>