// バーガーメニュー
const burgerButton = document.querySelector(".burger");
if (burgerButton) {
  const burgerToggle = burgerButton.querySelector(".burger-toggle");
  const navHide = document.querySelector(".nav-hide");

  burgerButton.addEventListener("click", () => {
    burgerToggle.classList.toggle("active");
    navHide.classList.toggle("active");
  });
}

// ===== jQuery の処理はここにまとめる =====
jQuery(function ($) {
  // スリック
  $(".slick-cards").slick({
    variableWidth: true,
    centerMode: true,
    centerPadding: "0px",
    slidesToShow: 3,
    slidesToScroll: 1,
    infinite: true,
    dots: false,
    arrows: true,
    autoplay: true,
    responsive: [
      { breakpoint: 1024, settings: { slidesToShow: 2, slidesToScroll: 1 } },
      { breakpoint: 768, settings: { slidesToShow: 1, slidesToScroll: 1 } },
    ],
  });

  $(".slick-cards").on("click", ".slick-prev", function () {
    $(this).addClass("clicked");
    $(".slick-next").removeClass("clicked");
  });

  $(".slick-cards").on("click", ".slick-next", function () {
    $(this).addClass("clicked");
    $(".slick-prev").removeClass("clicked");
  });

  // slick_second-cards
  $(".slick_second-cards").slick({
    variableWidth: true,
    centerMode: true,
    centerPadding: "0px",
    slidesToShow: 1,
    slidesToScroll: 1,
    infinite: true,
    dots: false,
    arrows: true,
    autoplay: false,
    responsive: [
      {
        breakpoint: 835,
        settings: {
          appendArrows: ".slick-arrows",
        },
      },
    ],
  });
});

// ===== jQueryを使わない=====

// ランダム順に並べ替え
document.addEventListener("DOMContentLoaded", function () {
  const cards = Array.from(document.querySelectorAll(".news-cards .card"));
  if (cards.length === 0) return;

  const observer = new IntersectionObserver(
    (entries) => {
      const visibleCards = entries
        .filter((entry) => entry.isIntersecting)
        .map((entry) => entry.target);

      visibleCards.sort(() => Math.random() - 0.5);

      visibleCards.forEach((card, index) => {
        setTimeout(() => {
          card.classList.add("animate");
        }, index * 150);
        observer.unobserve(card);
      });
    },
    { threshold: 0.5 }
  );

  cards.forEach((card) => observer.observe(card));
});
