<?php get_header(); ?>

<main class="l-main">

  <section class="s-article">
    <div class="wrapper">
      <div class="main-flex">
        <div class="flex-l">
          <ul class="select-block">
            <li>
              <div class="select-title">
                <div class="img">
                  <img src="<?php echo get_template_directory_uri(); ?>/images/icon-category.png" alt="icon-category">
                </div>
                <div class="en">Category</div>
              </div>

              <ul class="select-item select-category">
                <?php
                $categories = get_the_category();
                if (! empty($categories)) {
                  foreach ($categories as $category) {
                    echo '<li>' . esc_html($category->name) . '</li>';
                  }
                }
                ?>
              </ul>

            </li>
            <li>
              <div class="select-title">
                <div class="img">
                  <img src="<?php echo get_template_directory_uri(); ?>/images/icon-tag.png" alt="icon-tag">
                </div>
                <div class="en">Tag</div>
              </div>

              <ul class="select-item select-tag">
                <?php
                $tags = get_the_tags();
                if (! empty($tags)) {
                  foreach ($tags as $tag) {
                    echo '<li>＃' . esc_html($tag->name) . '</li>';
                  }
                }
                ?>
              </ul>
            </li>
          </ul>
        </div>
        <div class="flex-r">

          <?php if (has_post_thumbnail()) : ?>
            <div class="img">
              <?php the_post_thumbnail('full', array('alt' => get_the_title())); ?>
            </div>
          <?php endif; ?>


          <div class="article-blog">
            <time class="blog-date" datetime="<?php echo get_the_date('c'); ?>">
              <?php echo get_the_date('Y.n.j'); ?>
            </time>
            <h2 class="blog-title"><?php the_title(); ?></h2>

            <div class="content-body">
              <?php the_content(); ?>
            </div>

          </div>
        </div>

      </div>

    </div>
  </section>


  <div class="breadcrumb">
    <div class="wrapper">
      <ul class="breadcrumb__list">
        <?php get_template_part('template-parts/breadcrumb'); ?>
      </ul>
    </div>
  </div>



  <section class="s-category">
    <div class="wrapper">
      <ul class="category-body">
        <?php
        // 投稿のカテゴリを取得
        $current_cats = wp_get_post_categories(get_the_ID());

        // 現在の投稿カテゴリ + 未分類（ID 1）を除外
        $exclude_cats = array_merge($current_cats, array(1));

        // 除外したカテゴリ以外を取得
        $all_cats = get_categories(array(
          'exclude' => $exclude_cats,
          'hide_empty' => 0,
        ));

        foreach ($all_cats as $cat) :
        ?>
          <li class="category-item">
            <a href="<?php echo esc_url(get_category_link($cat->term_id)); ?>">
              <span class="en">Category</span>
              <?php echo esc_html($cat->name); ?>
            </a>
          </li>
        <?php endforeach; ?>
      </ul>
    </div>
  </section>



  <section class="s-slick_second">
    <div class="select-title">
      <div class="img">
        <img src="<?php echo get_template_directory_uri(); ?>/images/icon-booklink.png" alt="icon-booklink">
      </div>
      <div>関連記事</div>
    </div>

    <div class="slick_second-body">

      <ul class="slick_second-cards">
        <?php
        // 現在の投稿 ID
        $current_id = get_the_ID();

        // 現在の投稿カテゴリを取得
        $categories = wp_get_post_categories($current_id);

        // 関連記事クエリ
        $related_args = array(
          'post_type'      => 'post',
          'posts_per_page' => -1,
          'post__not_in'   => array($current_id),
          'category__in'   => $categories,
          'orderby'        => 'date',
          'order'          => 'DESC',
        );
        $related_query = new WP_Query($related_args);
        if ($related_query->have_posts()) :
          while ($related_query->have_posts()) : $related_query->the_post();
        ?>
            <?php get_template_part('template-parts/card-loop'); ?>
        <?php
          endwhile;
          wp_reset_postdata();
        else :
          echo '<li>関連記事はありません。</li>';
        endif;
        ?>
      </ul>
      <div class="slick-arrows"></div>
    </div>

  </section>




</main>
<?php get_footer(); ?>