    <!-- TOP -->
    <li class="breadcrumb__item"><a href="<?php echo home_url(); ?>">TOP</a></li>
    <li class="breadcrumb__separator">＞</li>

    <?php
    if (is_single()) :
      // 投稿ページの場合
      $categories = get_the_category();
      if (!empty($categories)) :
        $category = $categories[0];
    ?>
        <li class="breadcrumb__item"><a href="<?php echo esc_url(get_category_link($category->term_id)); ?>"><?php echo esc_html($category->name); ?></a></li>
        <li class="breadcrumb__separator">＞</li>
      <?php
      endif;
      ?>
      <li class="breadcrumb__item"><?php the_title(); ?></li>

    <?php elseif (is_category()) :
      // カテゴリページ
      $category = get_queried_object();
    ?>
      <li class="breadcrumb__item"><?php echo esc_html($category->name); ?></li>

    <?php elseif (is_tag()) :
      // タグページ
      $tag = get_queried_object();
    ?>
      <li class="breadcrumb__item"><?php echo esc_html($tag->name); ?></li>

    <?php elseif (isset($_GET['tag'])) :
      // 複数タグ選択ページ（例：?tag=tag1,tag2）
      $tags = explode(',', sanitize_text_field($_GET['tag']));
    ?>
      <li class="breadcrumb__item"><?php echo esc_html(implode(', ', $tags)); ?></li>

    <?php else : ?>
      <li class="breadcrumb__item">home</li>
    <?php endif; ?>